<?php 
	$wp_customize->add_panel( 'wpdevart_corporate_wda_single_post_page_panel', 
	array(
		'title'	=> esc_html__('Single Post/Page','corporate-wda'),			
		'description'	=> esc_html__('Single Post/Page settings','corporate-wda'),		
		'priority'		=> 25
	) 
	);

	##################------ Single Post ------##################

	$wp_customize->add_section('wpdevart_corporate_wda_single_post_section',array(
		'title'	=> esc_html__('Single Post','corporate-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_corporate_wda_single_post_page_panel'
	));

	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_width',array(
		'default'	=> esc_html('narrow'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_post_banner_width',array(
			'label'	=> esc_html__('Single post banner width','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_post_section',
			'setting'	=> 'wpdevart_corporate_wda_single_post_banner_width',
			'type' => 'select',
			'choices' => array(
				'narrow' => esc_html__('Narrow','corporate-wda'),
				'wide' => esc_html__('Wide','corporate-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_title_alignment',array(
		'default'	=> esc_html('center'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_post_title_alignment',array(
			'label'	=> esc_html__('Position of elements','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_post_section',
			'setting'	=> 'wpdevart_corporate_wda_single_post_title_alignment',
			'type' => 'select',
			'choices' => array(
				'left' => esc_html__('Left','corporate-wda'),
				'center' => esc_html__('Center','corporate-wda'),
				'right' => esc_html__('Right','corporate-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_bg_color', esc_html('#f9fafb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_bg_color', array(
        'label' => esc_html__('Single post banner BG color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_post_banner_gradient_type',array(
			'label'	=> esc_html__('Single post banner gradient type','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_post_section',
			'setting'	=> 'wpdevart_corporate_wda_single_post_banner_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','corporate-wda'),
				'to left' => esc_html__('To left','corporate-wda'),
				'to bottom' => esc_html__('To bottom','corporate-wda'),
				'to top' => esc_html__('To top','corporate-wda'),
				'to bottom right' => esc_html__('To bottom right','corporate-wda'),
				'to bottom left' => esc_html__('To bottom left','corporate-wda'),
				'to top right' => esc_html__('To top right','corporate-wda'),
				'to top left' => esc_html__('To top left','corporate-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_gradient_color', esc_html('#f9fafb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_gradient_color', array(
        'label' => esc_html__('Single post banner gradient color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_title_color', esc_html('#141414')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_title_color', array(
        'label' => esc_html__('Banner/Single Post title color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_title_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_entry_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_entry_text_color', esc_html('#1e1e1e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_entry_text_color', array(
        'label' => esc_html__('Banner text color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_entry_text_color'
    )));
	$wp_customize->add_setting( 'wpdevart_corporate_wda_post_banner_author_display',
    array(
       'default' => esc_html('1'),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_corporate_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_corporate_wda_post_banner_author_display',
        array(
        'label' => esc_html__( 'Show author/date/comment line', 'corporate-wda' ),
		'description' => esc_html__( 'Enable this option if you need to hide the author/date/comment line.', 'corporate-wda' ),
        'section' => 'wpdevart_corporate_wda_single_post_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_entry_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_entry_link_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_entry_link_color', array(
        'label' => esc_html__('Banner link color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_entry_link_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_post_banner_entry_link_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_post_banner_entry_link_hover_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_banner_entry_link_hover_color', array(
        'label' => esc_html__('Banner link hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_post_section',
        'settings' => 'wpdevart_corporate_wda_single_post_banner_entry_link_hover_color'
    )));
    $wp_customize->add_setting( 'wpdevart_corporate_wda_single_post_layout',
	array(
		'default' => esc_html('sidebarright'),
		'transport' => 'refresh',
		'sanitize_callback' => 'wpdevart_corporate_wda_text_sanitization'
	)
	);
	$wp_customize->add_control( new Wpdevart_Image_Radio_Button_Custom_Control( $wp_customize, 'wpdevart_corporate_wda_single_post_layout',
	array(
		'label' => esc_html__( 'Single Post Layout', 'corporate-wda' ),
		'description' => esc_html__( 'Choose the single post layout.', 'corporate-wda' ),
		'section' => 'wpdevart_corporate_wda_single_post_section',
		'choices' => array(
		'sidebarleft' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-left.png',
			'name' => esc_html__( 'Left Sidebar', 'corporate-wda' )
		),
		'sidebarnone' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-none.png',
			'name' => esc_html__( 'No Sidebar', 'corporate-wda' )
		),
		'sidebarright' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-right.png',
			'name' => esc_html__( 'Right Sidebar', 'corporate-wda' )
		)
		)
	)
	) );

	##################------ Single Page ------##################

	$wp_customize->add_section('wpdevart_corporate_wda_single_page_section',array(
		'title'	=> esc_html__('Single Page','corporate-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_corporate_wda_single_post_page_panel'
	));

	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_width',array(
		'default'	=> esc_html('narrow'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_page_banner_width',array(
			'label'	=> esc_html__('Single page banner width','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_page_section',
			'setting'	=> 'wpdevart_corporate_wda_single_page_banner_width',
			'type' => 'select',
			'choices' => array(
				'narrow' => esc_html__('Narrow','corporate-wda'),
				'wide' => esc_html__('Wide','corporate-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_title_alignment',array(
		'default'	=> esc_html('center'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_page_title_alignment',array(
			'label'	=> esc_html__('Position of elements','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_page_section',
			'setting'	=> 'wpdevart_corporate_wda_single_page_title_alignment',
			'type' => 'select',
			'choices' => array(
				'left' => esc_html__('Left','corporate-wda'),
				'center' => esc_html__('Center','corporate-wda'),
				'right' => esc_html__('Right','corporate-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_bg_color', esc_html('#f9fafb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_bg_color', array(
        'label' => esc_html__('Single page banner BG color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_corporate_wda_single_page_banner_gradient_type',array(
			'label'	=> esc_html__('Single page banner gradient type','corporate-wda'),
			'section'	=> 'wpdevart_corporate_wda_single_page_section',
			'setting'	=> 'wpdevart_corporate_wda_single_page_banner_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','corporate-wda'),
				'to left' => esc_html__('To left','corporate-wda'),
				'to bottom' => esc_html__('To bottom','corporate-wda'),
				'to top' => esc_html__('To top','corporate-wda'),
				'to bottom right' => esc_html__('To bottom right','corporate-wda'),
				'to bottom left' => esc_html__('To bottom left','corporate-wda'),
				'to top right' => esc_html__('To top right','corporate-wda'),
				'to top left' => esc_html__('To top left','corporate-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_gradient_color', esc_html('#f9fafb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_gradient_color', array(
        'label' => esc_html__('Single page banner gradient color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_title_color', esc_html('#141414')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_title_color', array(
        'label' => esc_html__('Banner/Single page title color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_title_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_entry_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_entry_text_color', esc_html('#1e1e1e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_entry_text_color', array(
        'label' => esc_html__('Banner text color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_entry_text_color'
    )));
	$wp_customize->add_setting( 'wpdevart_corporate_wda_page_banner_author_display',
    array(
       'default' => esc_html('1'),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_corporate_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_corporate_wda_page_banner_author_display',
        array(
        'label' => esc_html__( 'Show author/date/comment line', 'corporate-wda' ),
		'description' => esc_html__( 'Enable this option if you need to hide the author/date/comment line.', 'corporate-wda' ),
        'section' => 'wpdevart_corporate_wda_single_page_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_entry_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_entry_link_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_entry_link_color', array(
        'label' => esc_html__('Banner link color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_entry_link_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_single_page_banner_entry_link_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_single_page_banner_entry_link_hover_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_banner_entry_link_hover_color', array(
        'label' => esc_html__('Banner link hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_single_page_section',
        'settings' => 'wpdevart_corporate_wda_single_page_banner_entry_link_hover_color'
    )));
    $wp_customize->add_setting( 'wpdevart_corporate_wda_single_page_layout',
	array(
		'default' => esc_html('sidebarnone'),
		'transport' => 'refresh',
		'sanitize_callback' => 'wpdevart_corporate_wda_text_sanitization'
	)
	);
	$wp_customize->add_control( new Wpdevart_Image_Radio_Button_Custom_Control( $wp_customize, 'wpdevart_corporate_wda_single_page_layout',
	array(
		'label' => esc_html__( 'Single Page Layout', 'corporate-wda' ),
		'description' => esc_html__( 'Choose the single page layout.', 'corporate-wda' ),
		'section' => 'wpdevart_corporate_wda_single_page_section',
		'choices' => array(
		'sidebarleft' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-left.png',
			'name' => esc_html__( 'Left Sidebar', 'corporate-wda' )
		),
		'sidebarnone' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-none.png',
			'name' => esc_html__( 'No Sidebar', 'corporate-wda' )
		),
		'sidebarright' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-right.png',
			'name' => esc_html__( 'Right Sidebar', 'corporate-wda' )
		)
		)
	)
	) );

	##################------ Breadcrumbs ------##################

	$wp_customize->add_section('wpdevart_corporate_wda_breadcrumbs_section',array(
		'title'	=> esc_html__('Breadcrumbs','corporate-wda'),
		'description'	=> esc_html__('This section is for single posts and pages only. If you want to enable/edit WooCommerce breadcrumbs, you can do so from the WooCommerce WpDevArt section.','corporate-wda'),	
		'priority'		=> null,
		'panel'         => 'wpdevart_corporate_wda_single_post_page_panel'
	));

	$wp_customize->add_setting( 'wpdevart_corporate_wda_post_breadcrumbs_display_option',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_corporate_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_corporate_wda_post_breadcrumbs_display_option',
        array(
        'label' => esc_html__( 'Enable Post Breadcrumbs', 'corporate-wda' ),
		'description' => esc_html__( 'Check the option if you need to display the breadcrumbs for the single post.', 'corporate-wda' ),
        'section' => 'wpdevart_corporate_wda_breadcrumbs_section'
        )
    ) );
	$wp_customize->add_setting( 'wpdevart_corporate_wda_page_breadcrumbs_display_option',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_corporate_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_corporate_wda_page_breadcrumbs_display_option',
        array(
        'label' => esc_html__( 'Enable Page Breadcrumbs', 'corporate-wda' ),
		'description' => esc_html__( 'Check the option if you need to display the breadcrumbs for the single page.', 'corporate-wda' ),
        'section' => 'wpdevart_corporate_wda_breadcrumbs_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_corporate_wda_page_breadcrumbs_home_text',array(
		'default'	=> esc_html('Home'),'corporate-wda',
		'sanitize_callback'	=> 'wpdevart_corporate_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_corporate_wda_page_breadcrumbs_home_text',
            array(
                'label'    => esc_html__('Breadcrumb Home Text','corporate-wda'),
                'section'  => 'wpdevart_corporate_wda_breadcrumbs_section',
                'settings' => 'wpdevart_corporate_wda_page_breadcrumbs_home_text',
                'type'     => 'text'
            )
        )
    );

	##################------ Comments ------##################

	$wp_customize->add_section('wpdevart_corporate_wda_comments_settings',array(
		'title'	=> esc_html__('Comments Box','corporate-wda'),
		'description'	=> esc_html__('The Comment Box is a block of user responses. Other comments section settings can be managed on the General settings page (for example, the Post Comment button can be controlled in the Primary Button section, or the text colors for Comment*, Name*, Email*, or Website can be controlled in the Colors section).','corporate-wda'),	
		'priority'		=> null,
		'panel'         => 'wpdevart_corporate_wda_single_post_page_panel'
	));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_box_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_box_bg_color', esc_html('#fdfdfd')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_box_bg_color', array(
        'label' => esc_html__('Comments reply box background color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_box_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_box_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_box_text_color', esc_html('#1e1e1e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_box_text_color', array(
        'label' => esc_html__('Comments reply box text color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_box_text_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_box_heading_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_box_heading_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_box_heading_color', array(
        'label' => esc_html__('Comments reply box heading color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_box_heading_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_box_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_box_link_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_box_link_color', array(
        'label' => esc_html__('Comments reply box link color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_box_link_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_box_link_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_box_link_hover_color', esc_html('#fb5a53')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_box_link_hover_color', array(
        'label' => esc_html__('Comments reply box link hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_box_link_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_bg_color', esc_html('#fdfdfd')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_bg_color', array(
        'label' => esc_html__('Comments reply button bg color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_border_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_border_color', array(
        'label' => esc_html__('Comments reply button border color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_border_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_link_color', esc_html('#1183f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_link_color', array(
        'label' => esc_html__('Comments reply button link color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_link_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_bg_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_bg_hover_color', esc_html('#fdfdfd')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_bg_hover_color', array(
        'label' => esc_html__('Comments reply button bg hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_bg_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_border_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_border_hover_color', esc_html('#fb5a53')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_border_hover_color', array(
        'label' => esc_html__('Comments reply button border hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_border_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_corporate_wda_comments_reply_button_link_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_corporate_wda_comments_reply_button_link_hover_color', esc_html('#fb5a53')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_corporate_wda_comments_reply_button_link_hover_color', array(
        'label' => esc_html__('Comments reply button link hover color','corporate-wda'),
        'section' => 'wpdevart_corporate_wda_comments_settings',
        'settings' => 'wpdevart_corporate_wda_comments_reply_button_link_hover_color'
    )));