<?php 
    if (get_theme_mod( 'wpdevart_corporate_wda_top_header_layout') == 'phoneleft') {
    ?>
        <div class="wpdevart-top-header <?php if (empty(get_theme_mod( 'wpdevart_corporate_wda_top_header_bg_gradient_color' ))) 
                    { echo esc_attr( 'wpdevart-top-header-bg-color' ); } 
                    else { echo esc_attr('wpdevart-top-header-gradient-color'); } ?>
                    <?php if (get_theme_mod( 'wpdevart_corporate_wda_enable_top_header_border', '1' )) { } 
                    else { echo esc_attr( 'wpdevart-top-header-border' ); } ?>">

        <div class="wpdevart-top-header-section">
        <div class="wpdevart-top-header-left">
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) != '') ) { ?>
                    <span class="wpdevart-top-header-phone">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.26 1.289l-1.564.772c-5.793 3.02 2.798 20.944 9.31 20.944.46 0 .904-.094 1.317-.284l1.542-.755-2.898-5.594-1.54.754c-.181.087-.384.134-.597.134-2.561 0-6.841-8.204-4.241-9.596l1.546-.763-2.875-5.612zm7.746 22.711c-5.68 0-12.221-11.114-12.221-17.832 0-2.419.833-4.146 2.457-4.992l2.382-1.176 3.857 7.347-2.437 1.201c-1.439.772 2.409 8.424 3.956 7.68l2.399-1.179 3.816 7.36s-2.36 1.162-2.476 1.215c-.547.251-1.129.376-1.733.376"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) );  ?></span>
                    </span>
            <?php }   ?>
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) != '') ) { ?>
                    <span class="wpdevart-top-header-email">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
								<path d="M24 21h-24v-18h24v18zm-23-16.477v15.477h22v-15.477l-10.999 10-11.001-10zm21.089-.523h-20.176l10.088 9.171 10.088-9.171z"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) );  ?></span>
                    </span>
            <?php }   ?>
        </div>
        <div class="wpdevart-top-header-right">
        <div class="wpdevart-top-header-right-content">
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_twitter', '1' )) { } else { ?><span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_twitter_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="19" height="19" viewBox="1 0 48 48"><polygon points="41,6 9.929,42 6.215,42 37.287,6"></polygon><path d="M15.724,9l20.578,30h-4.106L11.618,9H15.724 M17.304,6H5.922l24.694,36h11.382L17.304,6L17.304,6z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_facebook', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_facebook_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_linkedin', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_linkedin_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="18" height="18" viewBox="1 0 30 30"><path d="M9,25H4V10h5V25z M6.501,8C5.118,8,4,6.879,4,5.499S5.12,3,6.501,3C7.879,3,9,4.121,9,5.499C9,6.879,7.879,8,6.501,8z M27,25h-4.807v-7.3c0-1.741-0.033-3.98-2.499-3.98c-2.503,0-2.888,1.896-2.888,3.854V25H12V9.989h4.614v2.051h0.065 c0.642-1.18,2.211-2.424,4.551-2.424c4.87,0,5.77,3.109,5.77,7.151C27,16.767,27,25,27,25z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_youtube', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_youtube_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_instagram', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_instagram_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg></a></span> <?php }; ?>
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_tiktok', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_tiktok_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 449.45 515.38"><path fill-rule="nonzero" d="M382.31 103.3c-27.76-18.1-47.79-47.07-54.04-80.82-1.35-7.29-2.1-14.8-2.1-22.48h-88.6l-.15 355.09c-1.48 39.77-34.21 71.68-74.33 71.68-12.47 0-24.21-3.11-34.55-8.56-23.71-12.47-39.94-37.32-39.94-65.91 0-41.07 33.42-74.49 74.48-74.49 7.67 0 15.02 1.27 21.97 3.44V190.8c-7.2-.99-14.51-1.59-21.97-1.59C73.16 189.21 0 262.36 0 352.3c0 55.17 27.56 104 69.63 133.52 26.48 18.61 58.71 29.56 93.46 29.56 89.93 0 163.08-73.16 163.08-163.08V172.23c34.75 24.94 77.33 39.64 123.28 39.64v-88.61c-24.75 0-47.8-7.35-67.14-19.96z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_pinterest', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_pinterest_url' ) );  ?>" target="_blank"><svg width="18" height="18" enable-background="new 0 0 512 512" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M232.2,336.4c-1.5,4.1-1.9,8.1-2.8,11.9c-3.9,15.7-6.9,31.6-10.7,47.3c-2.9,11.9-6,23.9-10.2,35.5   c-3.6,10.2-8.5,20.1-13.4,29.8c-7.6,15.3-16.9,29.7-27,43.4c-1.7,2.3-2.6,6.3-6.1,5.4c-4.2-1.1-3.5-5.4-3.9-8.8   c-2.9-21.7-3.7-43.4-3-65.2c0.4-11.4,0.8-23,3.6-34.1c2.9-11.3,5-22.8,7.7-34.1c1.9-8,3.7-16.2,4.9-24.4c1.1-7.7,4.1-15.1,5.3-22.7   c1.6-10.3,4.5-20.3,6.6-30.5c1.9-9.2,4.3-18.4,6.2-27.6c1.3-6.3,2.6-12.5,4.3-18.7c0.8-3,0.2-6.2-1.3-9.5c-4-8.8-4.9-18.5-6.3-27.9   c-1.8-12.1-0.8-24.3,2.1-36.1c4.5-18.1,11.7-34.7,28.4-45.5c18.5-11.9,44.6-6.5,52.8,15.2c5.2,14,4.1,27.8,2.1,42   c-1.7,12.3-5.4,24.1-8.8,35.9c-2.7,9.1-5.6,18.2-7.9,27.4c-1.8,7.5-5.2,14.9-4.8,22.9c0.2,4.4-0.8,8.7-0.5,13.3   c1.1,17.9,11.3,29.2,26.3,36c8.4,3.8,18.1,4,27.9,1.5c10.3-2.6,18.8-7.4,26.8-13.7c9.1-7.2,15.3-16.8,21.3-26.4   c6.2-9.9,10.3-21,13.8-32.1c4.5-14.6,7.6-29.7,9.7-45c1.6-12,1.6-23.9,1.9-35.8c0.5-21.9-5.1-42.4-15.6-61.2   c-6.5-11.7-16.2-20.9-27.3-29c-9.3-6.7-19.7-10.2-29.8-14.5c-3.4-1.5-7.3-1.7-10.9-2.6c-11.8-2.9-24-2.7-36-2.2   c-14.8,0.6-29.1,3.8-42.8,9.4c-14.5,6-27.5,14.5-38.7,25.4C164.4,102,155.2,115,148,129.5c-5.6,11.4-9.7,23.6-11.6,35.9   c-2.3,15.3-4.1,30.7-1.2,46.5c1.8,10.1,5,19.6,9.1,28.8c1.9,4.3,4.9,8.2,8.1,11.7c3.7,4.1,4.3,8.6,3.3,13.4   c-1.7,8.4-3.8,16.8-5.9,25.1c-1.6,6.4-8.9,9.3-15.1,6.2c-18.8-9.7-32.2-24.4-40.6-43.8C86.4,235.4,82,216.7,81.9,197   c-0.1-13.8-0.9-27.7,2.3-41.2c2.5-10.9,5.4-21.6,9.4-32.1c5.1-13.4,11.9-25.6,19.7-37.5c11.6-17.8,26.6-32.5,43.8-44.9   c13.1-9.5,27.4-17.3,42.5-22.7c9.5-3.4,19.3-5.9,29.3-8c17.9-3.6,35.8-4.9,53.8-4.3c9.7,0.3,19.2,2.7,28.8,4.1   c13,2,24.8,6.9,36.6,12c7.9,3.4,15.4,7.9,22.6,12.8c11.4,7.7,21.6,16.8,30.7,27c10.8,12,19.2,25.6,26.1,40.3   c3.4,7.1,5.7,14.6,8.9,21.8c1.4,3.1,1.8,6.9,2.3,10.4c0.9,5.8,1.6,11.8,2.8,17.4c2.5,11.8,1.6,23.5,1.2,35.1   c-0.3,9.9-1.1,19.9-3.4,29.7c-1.1,4.6-0.8,9.3-2,14.1c-2,7.7-3.8,15.5-5.9,23.2c-3.2,12-7.9,23.4-13.4,34.4   c-11.8,23.8-27.4,44.6-49.7,59.9c-7.9,5.4-16.1,10.2-25,13.7c-19.6,7.5-40.1,10.8-60.8,6.7c-19.1-3.8-35.5-13.1-47.3-29.4   C234.5,338.2,233.4,337.5,232.2,336.4z"/></svg></a></span> <?php }; ?>
        </div>
        </div>
        </div>
        </div>
    <?php  
    }  
    else if (get_theme_mod( 'wpdevart_corporate_wda_top_header_layout') == 'phonesocialcenter') {
    ?>
        <div class="wpdevart-top-header <?php if (empty(get_theme_mod( 'wpdevart_corporate_wda_top_header_bg_gradient_color' ))) 
        { echo esc_attr( 'wpdevart-top-header-bg-color' ); } 
        else { echo esc_attr('wpdevart-top-header-gradient-color'); } ?>
        <?php if (get_theme_mod( 'wpdevart_corporate_wda_enable_top_header_border', '1' )) { } 
        else { echo esc_attr( 'wpdevart-top-header-border' ); } ?>">
        <div class="wpdevart-top-header-section">
        <div class="wpdevart-top-header-left-content">
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) != '') ) { ?>
                    <span class="wpdevart-top-header-phone">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.26 1.289l-1.564.772c-5.793 3.02 2.798 20.944 9.31 20.944.46 0 .904-.094 1.317-.284l1.542-.755-2.898-5.594-1.54.754c-.181.087-.384.134-.597.134-2.561 0-6.841-8.204-4.241-9.596l1.546-.763-2.875-5.612zm7.746 22.711c-5.68 0-12.221-11.114-12.221-17.832 0-2.419.833-4.146 2.457-4.992l2.382-1.176 3.857 7.347-2.437 1.201c-1.439.772 2.409 8.424 3.956 7.68l2.399-1.179 3.816 7.36s-2.36 1.162-2.476 1.215c-.547.251-1.129.376-1.733.376"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) );  ?></span>
                    </span>
            <?php }   ?>
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) != '') ) { ?>
                    <span class="wpdevart-top-header-email">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
								<path d="M24 21h-24v-18h24v18zm-23-16.477v15.477h22v-15.477l-10.999 10-11.001-10zm21.089-.523h-20.176l10.088 9.171 10.088-9.171z"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) );  ?></span>
                    </span>
            <?php }   ?>
        </div>
        <div class="wpdevart-top-header-right-content">
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_twitter', '1' )) { } else { ?><span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_twitter_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="19" height="19" viewBox="1 0 48 48"><polygon points="41,6 9.929,42 6.215,42 37.287,6"></polygon><path d="M15.724,9l20.578,30h-4.106L11.618,9H15.724 M17.304,6H5.922l24.694,36h11.382L17.304,6L17.304,6z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_facebook', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_facebook_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_linkedin', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_linkedin_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="18" height="18" viewBox="1 0 30 30"><path d="M9,25H4V10h5V25z M6.501,8C5.118,8,4,6.879,4,5.499S5.12,3,6.501,3C7.879,3,9,4.121,9,5.499C9,6.879,7.879,8,6.501,8z M27,25h-4.807v-7.3c0-1.741-0.033-3.98-2.499-3.98c-2.503,0-2.888,1.896-2.888,3.854V25H12V9.989h4.614v2.051h0.065 c0.642-1.18,2.211-2.424,4.551-2.424c4.87,0,5.77,3.109,5.77,7.151C27,16.767,27,25,27,25z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_youtube', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_youtube_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_instagram', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_instagram_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg></a></span> <?php }; ?>
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_tiktok', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_tiktok_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 449.45 515.38"><path fill-rule="nonzero" d="M382.31 103.3c-27.76-18.1-47.79-47.07-54.04-80.82-1.35-7.29-2.1-14.8-2.1-22.48h-88.6l-.15 355.09c-1.48 39.77-34.21 71.68-74.33 71.68-12.47 0-24.21-3.11-34.55-8.56-23.71-12.47-39.94-37.32-39.94-65.91 0-41.07 33.42-74.49 74.48-74.49 7.67 0 15.02 1.27 21.97 3.44V190.8c-7.2-.99-14.51-1.59-21.97-1.59C73.16 189.21 0 262.36 0 352.3c0 55.17 27.56 104 69.63 133.52 26.48 18.61 58.71 29.56 93.46 29.56 89.93 0 163.08-73.16 163.08-163.08V172.23c34.75 24.94 77.33 39.64 123.28 39.64v-88.61c-24.75 0-47.8-7.35-67.14-19.96z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_pinterest', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_pinterest_url' ) );  ?>" target="_blank"><svg width="18" height="18" enable-background="new 0 0 512 512" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M232.2,336.4c-1.5,4.1-1.9,8.1-2.8,11.9c-3.9,15.7-6.9,31.6-10.7,47.3c-2.9,11.9-6,23.9-10.2,35.5   c-3.6,10.2-8.5,20.1-13.4,29.8c-7.6,15.3-16.9,29.7-27,43.4c-1.7,2.3-2.6,6.3-6.1,5.4c-4.2-1.1-3.5-5.4-3.9-8.8   c-2.9-21.7-3.7-43.4-3-65.2c0.4-11.4,0.8-23,3.6-34.1c2.9-11.3,5-22.8,7.7-34.1c1.9-8,3.7-16.2,4.9-24.4c1.1-7.7,4.1-15.1,5.3-22.7   c1.6-10.3,4.5-20.3,6.6-30.5c1.9-9.2,4.3-18.4,6.2-27.6c1.3-6.3,2.6-12.5,4.3-18.7c0.8-3,0.2-6.2-1.3-9.5c-4-8.8-4.9-18.5-6.3-27.9   c-1.8-12.1-0.8-24.3,2.1-36.1c4.5-18.1,11.7-34.7,28.4-45.5c18.5-11.9,44.6-6.5,52.8,15.2c5.2,14,4.1,27.8,2.1,42   c-1.7,12.3-5.4,24.1-8.8,35.9c-2.7,9.1-5.6,18.2-7.9,27.4c-1.8,7.5-5.2,14.9-4.8,22.9c0.2,4.4-0.8,8.7-0.5,13.3   c1.1,17.9,11.3,29.2,26.3,36c8.4,3.8,18.1,4,27.9,1.5c10.3-2.6,18.8-7.4,26.8-13.7c9.1-7.2,15.3-16.8,21.3-26.4   c6.2-9.9,10.3-21,13.8-32.1c4.5-14.6,7.6-29.7,9.7-45c1.6-12,1.6-23.9,1.9-35.8c0.5-21.9-5.1-42.4-15.6-61.2   c-6.5-11.7-16.2-20.9-27.3-29c-9.3-6.7-19.7-10.2-29.8-14.5c-3.4-1.5-7.3-1.7-10.9-2.6c-11.8-2.9-24-2.7-36-2.2   c-14.8,0.6-29.1,3.8-42.8,9.4c-14.5,6-27.5,14.5-38.7,25.4C164.4,102,155.2,115,148,129.5c-5.6,11.4-9.7,23.6-11.6,35.9   c-2.3,15.3-4.1,30.7-1.2,46.5c1.8,10.1,5,19.6,9.1,28.8c1.9,4.3,4.9,8.2,8.1,11.7c3.7,4.1,4.3,8.6,3.3,13.4   c-1.7,8.4-3.8,16.8-5.9,25.1c-1.6,6.4-8.9,9.3-15.1,6.2c-18.8-9.7-32.2-24.4-40.6-43.8C86.4,235.4,82,216.7,81.9,197   c-0.1-13.8-0.9-27.7,2.3-41.2c2.5-10.9,5.4-21.6,9.4-32.1c5.1-13.4,11.9-25.6,19.7-37.5c11.6-17.8,26.6-32.5,43.8-44.9   c13.1-9.5,27.4-17.3,42.5-22.7c9.5-3.4,19.3-5.9,29.3-8c17.9-3.6,35.8-4.9,53.8-4.3c9.7,0.3,19.2,2.7,28.8,4.1   c13,2,24.8,6.9,36.6,12c7.9,3.4,15.4,7.9,22.6,12.8c11.4,7.7,21.6,16.8,30.7,27c10.8,12,19.2,25.6,26.1,40.3   c3.4,7.1,5.7,14.6,8.9,21.8c1.4,3.1,1.8,6.9,2.3,10.4c0.9,5.8,1.6,11.8,2.8,17.4c2.5,11.8,1.6,23.5,1.2,35.1   c-0.3,9.9-1.1,19.9-3.4,29.7c-1.1,4.6-0.8,9.3-2,14.1c-2,7.7-3.8,15.5-5.9,23.2c-3.2,12-7.9,23.4-13.4,34.4   c-11.8,23.8-27.4,44.6-49.7,59.9c-7.9,5.4-16.1,10.2-25,13.7c-19.6,7.5-40.1,10.8-60.8,6.7c-19.1-3.8-35.5-13.1-47.3-29.4   C234.5,338.2,233.4,337.5,232.2,336.4z"/></svg></a></span> <?php }; ?>
        </div>
        </div>
        </div>
    <?php  
    }  
    else if (get_theme_mod( 'wpdevart_corporate_wda_top_header_layout') == 'phoneright') {
    ?>
        <div class="wpdevart-top-header <?php if (empty(get_theme_mod( 'wpdevart_corporate_wda_top_header_bg_gradient_color' ))) 
        { echo esc_attr( 'wpdevart-top-header-bg-color' ); } 
        else { echo esc_attr('wpdevart-top-header-gradient-color'); } ?>
        <?php if (get_theme_mod( 'wpdevart_corporate_wda_enable_top_header_border', '1' )) { } 
        else { echo esc_attr( 'wpdevart-top-header-border' ); } ?>">
        <div class="wpdevart-top-header-section">
        <div class="wpdevart-top-header-left-icons">
        <div class="wpdevart-top-header-left-icons-content">
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_twitter', '1' )) { } else { ?><span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_twitter_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="19" height="19" viewBox="1 0 48 48"><polygon points="41,6 9.929,42 6.215,42 37.287,6"></polygon><path d="M15.724,9l20.578,30h-4.106L11.618,9H15.724 M17.304,6H5.922l24.694,36h11.382L17.304,6L17.304,6z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_facebook', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_facebook_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_linkedin', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_linkedin_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="18" height="18" viewBox="1 0 30 30"><path d="M9,25H4V10h5V25z M6.501,8C5.118,8,4,6.879,4,5.499S5.12,3,6.501,3C7.879,3,9,4.121,9,5.499C9,6.879,7.879,8,6.501,8z M27,25h-4.807v-7.3c0-1.741-0.033-3.98-2.499-3.98c-2.503,0-2.888,1.896-2.888,3.854V25H12V9.989h4.614v2.051h0.065 c0.642-1.18,2.211-2.424,4.551-2.424c4.87,0,5.77,3.109,5.77,7.151C27,16.767,27,25,27,25z"></path></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_youtube', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_youtube_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M19.615 3.184c-3.604-.246-11.631-.245-15.23 0-3.897.266-4.356 2.62-4.385 8.816.029 6.185.484 8.549 4.385 8.816 3.6.245 11.626.246 15.23 0 3.897-.266 4.356-2.62 4.385-8.816-.029-6.185-.484-8.549-4.385-8.816zm-10.615 12.816v-8l8 3.993-8 4.007z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_instagram', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_instagram_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg></a></span> <?php }; ?>
			<?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_tiktok', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_tiktok_url' ) );  ?>" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 449.45 515.38"><path fill-rule="nonzero" d="M382.31 103.3c-27.76-18.1-47.79-47.07-54.04-80.82-1.35-7.29-2.1-14.8-2.1-22.48h-88.6l-.15 355.09c-1.48 39.77-34.21 71.68-74.33 71.68-12.47 0-24.21-3.11-34.55-8.56-23.71-12.47-39.94-37.32-39.94-65.91 0-41.07 33.42-74.49 74.48-74.49 7.67 0 15.02 1.27 21.97 3.44V190.8c-7.2-.99-14.51-1.59-21.97-1.59C73.16 189.21 0 262.36 0 352.3c0 55.17 27.56 104 69.63 133.52 26.48 18.61 58.71 29.56 93.46 29.56 89.93 0 163.08-73.16 163.08-163.08V172.23c34.75 24.94 77.33 39.64 123.28 39.64v-88.61c-24.75 0-47.8-7.35-67.14-19.96z"/></svg></a></span> <?php }; ?>
            <?php if (get_theme_mod( 'wpdevart_corporate_wda_top_header_disable_pinterest', '1' )) { } else { ?> <span class="wpdevart-social-icons"><a href="<?php echo esc_url( get_theme_mod( 'wpdevart_corporate_wda_top_header_pinterest_url' ) );  ?>" target="_blank"><svg width="18" height="18" enable-background="new 0 0 512 512" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M232.2,336.4c-1.5,4.1-1.9,8.1-2.8,11.9c-3.9,15.7-6.9,31.6-10.7,47.3c-2.9,11.9-6,23.9-10.2,35.5   c-3.6,10.2-8.5,20.1-13.4,29.8c-7.6,15.3-16.9,29.7-27,43.4c-1.7,2.3-2.6,6.3-6.1,5.4c-4.2-1.1-3.5-5.4-3.9-8.8   c-2.9-21.7-3.7-43.4-3-65.2c0.4-11.4,0.8-23,3.6-34.1c2.9-11.3,5-22.8,7.7-34.1c1.9-8,3.7-16.2,4.9-24.4c1.1-7.7,4.1-15.1,5.3-22.7   c1.6-10.3,4.5-20.3,6.6-30.5c1.9-9.2,4.3-18.4,6.2-27.6c1.3-6.3,2.6-12.5,4.3-18.7c0.8-3,0.2-6.2-1.3-9.5c-4-8.8-4.9-18.5-6.3-27.9   c-1.8-12.1-0.8-24.3,2.1-36.1c4.5-18.1,11.7-34.7,28.4-45.5c18.5-11.9,44.6-6.5,52.8,15.2c5.2,14,4.1,27.8,2.1,42   c-1.7,12.3-5.4,24.1-8.8,35.9c-2.7,9.1-5.6,18.2-7.9,27.4c-1.8,7.5-5.2,14.9-4.8,22.9c0.2,4.4-0.8,8.7-0.5,13.3   c1.1,17.9,11.3,29.2,26.3,36c8.4,3.8,18.1,4,27.9,1.5c10.3-2.6,18.8-7.4,26.8-13.7c9.1-7.2,15.3-16.8,21.3-26.4   c6.2-9.9,10.3-21,13.8-32.1c4.5-14.6,7.6-29.7,9.7-45c1.6-12,1.6-23.9,1.9-35.8c0.5-21.9-5.1-42.4-15.6-61.2   c-6.5-11.7-16.2-20.9-27.3-29c-9.3-6.7-19.7-10.2-29.8-14.5c-3.4-1.5-7.3-1.7-10.9-2.6c-11.8-2.9-24-2.7-36-2.2   c-14.8,0.6-29.1,3.8-42.8,9.4c-14.5,6-27.5,14.5-38.7,25.4C164.4,102,155.2,115,148,129.5c-5.6,11.4-9.7,23.6-11.6,35.9   c-2.3,15.3-4.1,30.7-1.2,46.5c1.8,10.1,5,19.6,9.1,28.8c1.9,4.3,4.9,8.2,8.1,11.7c3.7,4.1,4.3,8.6,3.3,13.4   c-1.7,8.4-3.8,16.8-5.9,25.1c-1.6,6.4-8.9,9.3-15.1,6.2c-18.8-9.7-32.2-24.4-40.6-43.8C86.4,235.4,82,216.7,81.9,197   c-0.1-13.8-0.9-27.7,2.3-41.2c2.5-10.9,5.4-21.6,9.4-32.1c5.1-13.4,11.9-25.6,19.7-37.5c11.6-17.8,26.6-32.5,43.8-44.9   c13.1-9.5,27.4-17.3,42.5-22.7c9.5-3.4,19.3-5.9,29.3-8c17.9-3.6,35.8-4.9,53.8-4.3c9.7,0.3,19.2,2.7,28.8,4.1   c13,2,24.8,6.9,36.6,12c7.9,3.4,15.4,7.9,22.6,12.8c11.4,7.7,21.6,16.8,30.7,27c10.8,12,19.2,25.6,26.1,40.3   c3.4,7.1,5.7,14.6,8.9,21.8c1.4,3.1,1.8,6.9,2.3,10.4c0.9,5.8,1.6,11.8,2.8,17.4c2.5,11.8,1.6,23.5,1.2,35.1   c-0.3,9.9-1.1,19.9-3.4,29.7c-1.1,4.6-0.8,9.3-2,14.1c-2,7.7-3.8,15.5-5.9,23.2c-3.2,12-7.9,23.4-13.4,34.4   c-11.8,23.8-27.4,44.6-49.7,59.9c-7.9,5.4-16.1,10.2-25,13.7c-19.6,7.5-40.1,10.8-60.8,6.7c-19.1-3.8-35.5-13.1-47.3-29.4   C234.5,338.2,233.4,337.5,232.2,336.4z"/></svg></a></span> <?php }; ?>
        </div>
        </div>
        <div class="wpdevart-top-header-right-content">
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) != '') ) { ?>
                    <span class="wpdevart-top-header-phone">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<path d="M8.26 1.289l-1.564.772c-5.793 3.02 2.798 20.944 9.31 20.944.46 0 .904-.094 1.317-.284l1.542-.755-2.898-5.594-1.54.754c-.181.087-.384.134-.597.134-2.561 0-6.841-8.204-4.241-9.596l1.546-.763-2.875-5.612zm7.746 22.711c-5.68 0-12.221-11.114-12.221-17.832 0-2.419.833-4.146 2.457-4.992l2.382-1.176 3.857 7.347-2.437 1.201c-1.439.772 2.409 8.424 3.956 7.68l2.399-1.179 3.816 7.36s-2.36 1.162-2.476 1.215c-.547.251-1.129.376-1.733.376"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_phone_number' ) );  ?></span>
                    </span>
            <?php }   ?>
            <?php if ( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) OR (get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) != '') ) { ?>
                    <span class="wpdevart-top-header-email">
                        <span class="wpdevart-phone-email-icon">
							<svg class="top-header-icons" width="22" height="22" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
								<path d="M24 21h-24v-18h24v18zm-23-16.477v15.477h22v-15.477l-10.999 10-11.001-10zm21.089-.523h-20.176l10.088 9.171 10.088-9.171z"/>
							</svg>
						</span>
                        <span class="wpdevart-phone-email-text"><?php echo esc_html( get_theme_mod( 'wpdevart_corporate_wda_top_header_email' ) );  ?></span>
                    </span>
            <?php }   ?>
        </div>
        </div>
        </div>
    <?php  
    }  
?>