<?php 
	$wp_customize->add_panel( 'wpdevart_church_wda_blog_archive_search_panel', 
	array(
		'title'	=> esc_html__('Blog/Archive/Search','church-wda'),			
		'description'	=> esc_html__('Blog/Archive/Search pages settings','church-wda'),		
		'priority'		=> 27
	) 
	);

	##################------ Blog/Archive Page ------##################

	$wp_customize->add_section('wpdevart_church_wda_blog_section',array(
		'title'	=> esc_html__('Blog/Archive Page','church-wda'),
		'priority'		=> null,
		'panel'         => 'wpdevart_church_wda_blog_archive_search_panel'
	));
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_width',array(
		'default'	=> esc_html('narrow'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_archive_banner_width',array(
			'label'	=> esc_html__('Blog/Archive banner width','church-wda'),
			'section'	=> 'wpdevart_church_wda_blog_section',
			'setting'	=> 'wpdevart_church_wda_archive_banner_width',
			'type' => 'select',
			'choices' => array(
				'narrow' => esc_html__('Narrow','church-wda'),
				'wide' => esc_html__('Wide','church-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_title_alignment',array(
		'default'	=> esc_html('center'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_archive_banner_title_alignment',array(
			'label'	=> esc_html__('Blog/Archive title alignment','church-wda'),
			'section'	=> 'wpdevart_church_wda_blog_section',
			'setting'	=> 'wpdevart_church_wda_archive_banner_title_alignment',
			'type' => 'select',
			'choices' => array(
				'left' => esc_html__('Left','church-wda'),
				'center' => esc_html__('Center','church-wda'),
				'right' => esc_html__('Right','church-wda')
				)
	));	
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_archive_banner_bg_color', esc_html('#10100e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_archive_banner_bg_color', array(
        'label' => esc_html__('Blog/Archive banner background color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_section',
        'settings' => 'wpdevart_church_wda_archive_banner_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_bg_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_archive_banner_bg_gradient_type',array(
			'label'	=> esc_html__('Archive pages banner gradient type','church-wda'),
			'section'	=> 'wpdevart_church_wda_blog_section',
			'setting'	=> 'wpdevart_church_wda_archive_banner_bg_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','church-wda'),
				'to left' => esc_html__('To left','church-wda'),
				'to bottom' => esc_html__('To bottom','church-wda'),
				'to top' => esc_html__('To top','church-wda'),
				'to bottom right' => esc_html__('To bottom right','church-wda'),
				'to bottom left' => esc_html__('To bottom left','church-wda'),
				'to top right' => esc_html__('To top right','church-wda'),
				'to top left' => esc_html__('To top left','church-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_archive_banner_bg_gradient_color', esc_html('#10100e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_archive_banner_bg_gradient_color', array(
        'label' => esc_html__('Archive pages banner gradient color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_section',
        'settings' => 'wpdevart_church_wda_archive_banner_bg_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_archive_banner_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_archive_banner_title_color', esc_html('#f5f5f5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_archive_banner_title_color', array(
        'label' => esc_html__('Blog/Archive title color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_section',
        'settings' => 'wpdevart_church_wda_archive_banner_title_color'
    )));
    $wp_customize->add_setting( 'wpdevart_church_wda_blog_archive_page_layout',
	array(
		'default' => esc_html('sidebarright'),
		'transport' => 'refresh',
		'sanitize_callback' => 'wpdevart_church_wda_text_sanitization'
	)
	);
	$wp_customize->add_control( new Wpdevart_Image_Radio_Button_Custom_Control( $wp_customize, 'wpdevart_church_wda_blog_archive_page_layout',
	array(
		'label' => esc_html__( 'Blog/Archive Page Layout', 'church-wda' ),
		'description' => esc_html__( 'Choose the blog/archive page layout.', 'church-wda' ),
		'section' => 'wpdevart_church_wda_blog_section',
		'choices' => array(
		'sidebarleft' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-left.png',
			'name' => esc_html__( 'Left Sidebar', 'church-wda' )
		),
		'sidebarnone' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-none.png',
			'name' => esc_html__( 'No Sidebar', 'church-wda' )
		),
		'sidebarright' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-right.png',
			'name' => esc_html__( 'Right Sidebar', 'church-wda' )
		)
		)
	)
	) );

	##################------ Search Page ------##################

	$wp_customize->add_section('wpdevart_church_wda_search_page_section',array(
		'title'	=> esc_html__('Search Page','church-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_church_wda_blog_archive_search_panel'
	));


	$wp_customize->add_setting('wpdevart_church_wda_search_banner_width',array(
		'default'	=> esc_html('narrow'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_search_banner_width',array(
			'label'	=> esc_html__('Search page banner width','church-wda'),
			'section'	=> 'wpdevart_church_wda_search_page_section',
			'setting'	=> 'wpdevart_church_wda_search_banner_width',
			'type' => 'select',
			'choices' => array(
				'narrow' => esc_html__('Narrow','church-wda'),
				'wide' => esc_html__('Wide','church-wda')
				)
	));
	$wp_customize->add_setting('wpdevart_church_wda_search_banner_title_alignment',array(
		'default'	=> esc_html('center'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_search_banner_title_alignment',array(
			'label'	=> esc_html__('Search page title alignment','church-wda'),
			'section'	=> 'wpdevart_church_wda_search_page_section',
			'setting'	=> 'wpdevart_church_wda_search_banner_title_alignment',
			'type' => 'select',
			'choices' => array(
				'left' => esc_html__('Left','church-wda'),
				'center' => esc_html__('Center','church-wda'),
				'right' => esc_html__('Right','church-wda')
				)
	));
	$wp_customize->add_setting('wpdevart_church_wda_search_banner_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_search_banner_bg_color', esc_html('#10100e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_search_banner_bg_color', array(
		'label' => esc_html__('Search page banner background color','church-wda'),
		'section' => 'wpdevart_church_wda_search_page_section',
		'settings' => 'wpdevart_church_wda_search_banner_bg_color'
	)));
	$wp_customize->add_setting('wpdevart_church_wda_search_banner_bg_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_search_banner_bg_gradient_type',array(
			'label'	=> esc_html__('Search page banner gradient type','church-wda'),
			'section'	=> 'wpdevart_church_wda_search_page_section',
			'setting'	=> 'wpdevart_church_wda_search_banner_bg_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','church-wda'),
				'to left' => esc_html__('To left','church-wda'),
				'to bottom' => esc_html__('To bottom','church-wda'),
				'to top' => esc_html__('To top','church-wda'),
				'to bottom right' => esc_html__('To bottom right','church-wda'),
				'to bottom left' => esc_html__('To bottom left','church-wda'),
				'to top right' => esc_html__('To top right','church-wda'),
				'to top left' => esc_html__('To top left','church-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_church_wda_search_banner_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_search_banner_bg_gradient_color', esc_html('#10100e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_search_banner_bg_gradient_color', array(
        'label' => esc_html__('Search page banner gradient color','church-wda'),
        'section' => 'wpdevart_church_wda_search_page_section',
        'settings' => 'wpdevart_church_wda_search_banner_bg_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_search_banner_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_search_banner_title_color', esc_html('#f5f5f5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_search_banner_title_color', array(
		'label' => esc_html__('Search page title color','church-wda'),
		'section' => 'wpdevart_church_wda_search_page_section',
		'settings' => 'wpdevart_church_wda_search_banner_title_color'
	)));	
	$wp_customize->add_setting( 'wpdevart_church_wda_search_page_layout',
	array(
		'default' => esc_html('sidebarright'),
		'transport' => 'refresh',
		'sanitize_callback' => 'wpdevart_church_wda_text_sanitization'
	)
	);
	$wp_customize->add_control( new Wpdevart_Image_Radio_Button_Custom_Control( $wp_customize, 'wpdevart_church_wda_search_page_layout',
	array(
		'label' => esc_html__( 'Search Page Layout', 'church-wda' ),
		'description' => esc_html__( 'Choose the search page layout.', 'church-wda' ),
		'section' => 'wpdevart_church_wda_search_page_section',
		'choices' => array(
		'sidebarleft' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-left.png',
			'name' => esc_html__( 'Left Sidebar', 'church-wda' )
		),
		'sidebarnone' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-none.png',
			'name' => esc_html__( 'No Sidebar', 'church-wda' )
		),
		'sidebarright' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/sidebar-right.png',
			'name' => esc_html__( 'Right Sidebar', 'church-wda' )
		)
		)
	)
	) );
	$wp_customize->add_setting('wpdevart_church_wda_search_page_button_style',array(
		'default'	=> esc_html('wpdevart_church_wda_primary_button_slide primary_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_church_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_church_wda_search_page_button_style',array(
			'label'	=> esc_html__('Search button color','church-wda'),
			'section'	=> 'wpdevart_church_wda_search_page_section',
			'setting'	=> 'wpdevart_church_wda_search_page_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_church_wda_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'church-wda'),
				'wpdevart_church_wda_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'church-wda'),
				'wpdevart_church_wda_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'church-wda'),
				'wpdevart_church_wda_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'church-wda'),
				'wpdevart_church_wda_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'church-wda'),
				'wpdevart_church_wda_fourth_button_slide fourth_btn_slide_right' => esc_html__('Dark', 'church-wda'),
				'wpdevart_church_wda_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'church-wda'),
				'wpdevart_church_wda_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'church-wda'),
				'wpdevart_church_wda_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'church-wda'),
				'wpdevart_church_wda_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'church-wda'),
				)
	));

	##################------ General ------##################
	
	$wp_customize->add_section('wpdevart_church_wda_blog_archive_search_general_section',array(
		'title'	=> esc_html__('General','church-wda'),
		'description'	=> esc_html__('This is the global options page for the Blog/Archive/Search posts lists.','church-wda'),
		'priority'		=> null,
		'panel'         => 'wpdevart_church_wda_blog_archive_search_panel'
	));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_posts_list_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_posts_list_bg_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_posts_list_bg_color', array(
        'label' => esc_html__('Summary/Post/Page block background color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_posts_list_bg_color'
    )));
	$wp_customize->add_setting( 'wpdevart_church_wda_blog_archive_display_default_featured_image',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_church_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_church_wda_blog_archive_display_default_featured_image',
        array(
        'label' => esc_html__( 'Enable Default Featured Image', 'church-wda' ),
		'description' => esc_html__( 'Display the default featured image for posts that do not have a selected featured image.', 'church-wda' ),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section'
        )
    ) );
	$wp_customize->add_setting( 'wpdevart_church_wda_blog_settings_title_font_size',
    array(
       'default' => esc_html('22'),
       'sanitize_callback' => 'wpdevart_church_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_title_font_size',
		array(
		'label' => esc_html__( 'Title font-size (px)', 'church-wda' ),
		'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
		'input_attrs' => array(
			'min' => esc_html('15'),
			'max' => esc_html('50'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_title_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_title_color', array(
        'label' => esc_html__('Title color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_title_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_title_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_title_hover_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_title_hover_color', array(
        'label' => esc_html__('Title hover color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_title_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_title_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_title_border_color', esc_html('#433e37')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_title_border_color', array(
        'label' => esc_html__('Title border color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_title_border_color'
    )));
	$wp_customize->add_setting( 'wpdevart_church_wda_blog_settings_metas_font_size',
    array(
       'default' => esc_html('12'),
       'sanitize_callback' => 'wpdevart_church_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_metas_font_size',
		array(
		'label' => esc_html__( 'Entry metas font-size (px)', 'church-wda' ),
		'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
		'input_attrs' => array(
			'min' => esc_html('10'),
			'max' => esc_html('30'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_metas_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_metas_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_metas_color', array(
        'label' => esc_html__('Color of the metas','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_metas_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_metas_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_metas_hover_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_metas_hover_color', array(
        'label' => esc_html__('Entry metas hover color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_metas_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_meta_icons_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_meta_icons_color', esc_html('#ffc88e')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_meta_icons_color', array(
        'label' => esc_html__('Icons color of the metas','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_meta_icons_color'
    )));
	$wp_customize->add_setting( 'wpdevart_church_wda_blog_settings_content_text_font_size',
    array(
       'default' => esc_html('15'),
       'sanitize_callback' => 'wpdevart_church_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_content_text_font_size',
		array(
		'label' => esc_html__( 'Content font-size (px)', 'church-wda' ),
		'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
		'input_attrs' => array(
			'min' => esc_html('10'),
			'max' => esc_html('40'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_content_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_content_text_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_content_text_color', array(
        'label' => esc_html__('Content text color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_content_text_color'
    )));
	$wp_customize->add_setting( 'wpdevart_church_wda_blog_settings_category_text_font_size',
    array(
       'default' => esc_html('13'),
       'sanitize_callback' => 'wpdevart_church_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_text_font_size',
		array(
		'label' => esc_html__( 'Category font-size (px)', 'church-wda' ),
		'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
		'input_attrs' => array(
			'min' => esc_html('10'),
			'max' => esc_html('40'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_bg_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_bg_color', array(
        'label' => esc_html__('Categories background color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_border_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_border_color', array(
        'label' => esc_html__('Categories border color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_border_color'
    )));	
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_text_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_text_color', array(
        'label' => esc_html__('Categories text color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_text_color'
    )));	
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_bg_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_bg_hover_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_bg_hover_color', array(
        'label' => esc_html__('Categories background hover color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_bg_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_border_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_border_hover_color', esc_html('#ebebeb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_border_hover_color', array(
        'label' => esc_html__('Categories border hover color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_border_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_blog_settings_category_text_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_blog_settings_category_text_hover_color', esc_html('#ebebeb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_blog_settings_category_text_hover_color', array(
        'label' => esc_html__('Categories text hover color','church-wda'),
        'section' => 'wpdevart_church_wda_blog_archive_search_general_section',
        'settings' => 'wpdevart_church_wda_blog_settings_category_text_hover_color'
    )));

	##################------ Pagination ------##################

	$wp_customize->add_section('wpdevart_church_wda_pagination_settings',array(
		'title'	=> esc_html__('Pagination','church-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_church_wda_blog_archive_search_panel'
	));

	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_bg_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_bg_color', array(
        'label' => esc_html__('Buttons background color','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_border_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_border_color', array(
        'label' => esc_html__('Buttons border color','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_border_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_link_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_link_color', array(
        'label' => esc_html__('Text color of active buttons','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_link_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_text_color', esc_html('#c9b29f')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_text_color', array(
        'label' => esc_html__('Text color of inactive buttons','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_text_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_bg_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_bg_hover_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_bg_hover_color', array(
        'label' => esc_html__('Buttons background hover color','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_bg_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_border_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_border_hover_color', esc_html('#ebebeb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_border_hover_color', array(
        'label' => esc_html__('Buttons border hover color','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_border_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_link_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_link_hover_color', esc_html('#ebebeb')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_link_hover_color', array(
        'label' => esc_html__('Text color of active buttons on hover','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_link_hover_color'
    )));
	$wp_customize->add_setting('wpdevart_church_wda_pagination_buttons_text_hover_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_church_wda_pagination_buttons_text_hover_color', esc_html('#c9b29f')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_church_wda_pagination_buttons_text_hover_color', array(
        'label' => esc_html__('Text color of inactive buttons on hover','church-wda'),
        'section' => 'wpdevart_church_wda_pagination_settings',
        'settings' => 'wpdevart_church_wda_pagination_buttons_text_hover_color'
    )));