<?php
	$wp_customize->add_panel( 'wpdevart_education_wda_custom_homepage_panel', 
    array(
		'title'	=> esc_html__('Custom Homepage','education-wda'),
        'description'	=> esc_html__('Customize the theme custom homepage','education-wda'),		
		'priority'		=> 28
    ) 
	);
	$wp_customize->add_section('wpdevart_education_wda_custom_homepage_section',array(
		'title'	=> esc_html__('Enable Custom Homepage','education-wda'),
		'priority'		=> null,
		'panel'         => 'wpdevart_education_wda_custom_homepage_panel'
	));
    $wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_display_option',
    array(
       'default' => esc_html('1'),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_education_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_education_wda_custom_homepage_display_option',
        array(
        'label' => esc_html__( 'Enable custom homepage', 'education-wda' ),
		'description' => esc_html__( 'Display custom homepage instead of the latest posts', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_section'
        )
    ) );
	
	$wp_customize->add_section('wpdevart_education_wda_custom_homepage_banner_section',array(
		'title'	=> esc_html__('Banner Section','education-wda'),
		'priority'		=> null,
		'panel'         => 'wpdevart_education_wda_custom_homepage_panel'
	));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_theme',array(
		'default'	=> esc_html('banner-first-theme'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));

	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_banner_theme',array(
			'label'	=> esc_html__('Banner Theme','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_banner_theme',
			'type' => 'select',
			'choices' => array(
				'banner-first-theme' => esc_html__('First Theme', 'education-wda'),
				'banner-second-theme' => esc_html__('Second Theme', 'education-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_education_wda_homepage_large_banner_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_homepage_large_banner_bg_color', esc_html('#020202')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_homepage_large_banner_bg_color', array(
        'label' => esc_html__('Banner background color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_homepage_large_banner_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_homepage_large_banner_bg_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'
	));
	$wp_customize->add_control('wpdevart_education_wda_homepage_large_banner_bg_gradient_type',array(
			'label'	=> esc_html__('Gradient type','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_homepage_large_banner_bg_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','education-wda'),
				'to left' => esc_html__('To left','education-wda'),
				'to bottom' => esc_html__('To bottom','education-wda'),
				'to top' => esc_html__('To top','education-wda'),
				'to bottom right' => esc_html__('To bottom right','education-wda'),
				'to bottom left' => esc_html__('To bottom left','education-wda'),
				'to top right' => esc_html__('To top right','education-wda'),
				'to top left' => esc_html__('To top left','education-wda'),
				)
	));
	$wp_customize->add_setting('wpdevart_education_wda_homepage_large_banner_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_homepage_large_banner_bg_gradient_color', esc_html('#020202')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_homepage_large_banner_bg_gradient_color', array(
        'label' => esc_html__('Banner background gradient color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_homepage_large_banner_bg_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_short_description',array(
		'default'	=> esc_html('Tech Tailored for Academic Excellence. Connect, Create, Educate!'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_short_description',
            array(
                'label'    => esc_html__('Banner short description','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_short_description',
                'type'     => 'text'
            )
        )
    );
    $wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_banner_short_description_font_size',
    array(
       'default' => esc_html('17'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_short_description_font_size',
		array(
		'label' => esc_html__( 'Short description font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
		'input_attrs' => array(
			'min' => esc_html('1'),
			'max' => esc_html('35'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_short_description_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_banner_short_description_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_short_description_color', array(
        'label' => esc_html__('Short description color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_short_description_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_title',array(
		'default'	=> esc_html('Education WDA'),'education-wda',
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_title',
            array(
                'label'    => esc_html__('Banner title','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_title',
                'type'     => 'text'
            )
        )
    );
    $wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_banner_title_font_size',
    array(
       'default' => esc_html('43'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_title_font_size',
		array(
		'label' => esc_html__( 'Title font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
		'input_attrs' => array(
			'min' => esc_html('1'),
			'max' => esc_html('90'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_banner_title_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_title_color', array(
        'label' => esc_html__('Banner title color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_title_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_sliding_first_text',array(
		'default'	=> esc_html('Qualified Teachers'),'education-wda',
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_sliding_first_text',
            array(
                'label'    => esc_html__('First sliding text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_sliding_first_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_sliding_second_text',array(
		'default'	=> esc_html('Online Courses'),'education-wda',
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_sliding_second_text',
            array(
                'label'    => esc_html__('Second sliding text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_sliding_second_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_sliding_third_text',array(
		'default'	=> esc_html('Doctorate Program'),'education-wda',
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_sliding_third_text',
            array(
                'label'    => esc_html__('Third sliding text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_sliding_third_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_sliding_fourth_text',array(
		'default'	=> esc_html('Learning Tools'),'education-wda',
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_sliding_fourth_text',
            array(
                'label'    => esc_html__('Fourth sliding text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_sliding_fourth_text',
                'type'     => 'text'
            )
        )
    );
    $wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_banner_sliding_text_font_size',
    array(
       'default' => esc_html('37'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_sliding_text_font_size',
		array(
		'label' => esc_html__( 'Sliding text font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
		'input_attrs' => array(
			'min' => esc_html('35'),
			'max' => esc_html('40'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_sliding_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_banner_sliding_text_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_sliding_text_color', array(
        'label' => esc_html__('Sliding text title color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_sliding_text_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_content',array(
		'default'	=> esc_html('The Education WDA offers a variety of services, including a doctorate program, online courses, and learning tools. Use the navigation buttons below to find out more information about us and our services. Share and tell your friends about it.'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_content',
            array(
                'label'    => esc_html__('Banner content text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_content',
                'type'     => 'text'
            )
        )
    );
    $wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_banner_content_font_size',
    array(
       'default' => esc_html('17'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_content_font_size',
		array(
		'label' => esc_html__( 'Content text font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
		'input_attrs' => array(
			'min' => esc_html('1'),
			'max' => esc_html('35'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_content_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_banner_content_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_content_color', array(
        'label' => esc_html__('Banner content text color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_content_color'
    )));
	$wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_show_banner_first_button',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_education_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_education_wda_custom_homepage_show_banner_first_button',
        array(
        'label' => esc_html__( 'Hide the first button', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_first_button_text',array(
		'default'	=> esc_html('Start Learning Now'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_first_button_text',
            array(
                'label'    => esc_html__('First button text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_first_button_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_first_button_url',array(
		'default'	=> esc_url('#'),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_banner_first_button_url',array(
			'label'	=> esc_html__('First button URL','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_banner_first_button_url'
	));	
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_first_button_style',array(
		'default'	=> esc_html('wpdevart_education_wda_primary_button_slide primary_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));

	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_banner_first_button_style',array(
			'label'	=> esc_html__('First button color','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_banner_first_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_education_wda_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'education-wda'),
				'wpdevart_education_wda_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'education-wda'),
				'wpdevart_education_wda_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'education-wda'),
				'wpdevart_education_wda_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'education-wda'),
				'wpdevart_education_wda_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'education-wda'),
				'wpdevart_education_wda_fourth_button_slide fourth_btn_slide_right' => esc_html__('Dark', 'education-wda'),
				'wpdevart_education_wda_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'education-wda'),
				'wpdevart_education_wda_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'education-wda'),
				'wpdevart_education_wda_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'education-wda'),
				'wpdevart_education_wda_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'education-wda'),
				)
	));
	$wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_show_banner_second_button',
    array(
       'default' => esc_html('1'),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_education_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_education_wda_custom_homepage_show_banner_second_button',
        array(
        'label' => esc_html__( 'Hide the second button', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_second_button_text',array(
		'default'	=> esc_html('Learn More'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_banner_second_button_text',
            array(
                'label'    => esc_html__('Second button text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_banner_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_banner_second_button_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_second_button_url',array(
		'default'	=> esc_url('#'),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_banner_second_button_url',array(
			'label'	=> esc_html__('Second button URL','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_banner_second_button_url'
	));	
	
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_second_button_style',array(
		'default'	=> esc_html('wpdevart_education_wda_secondary_button_slide secondary_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));

	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_banner_second_button_style',array(
			'label'	=> esc_html__('Second button color','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_banner_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_banner_second_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_education_wda_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'education-wda'),
				'wpdevart_education_wda_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'education-wda'),
				'wpdevart_education_wda_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'education-wda'),
				'wpdevart_education_wda_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'education-wda'),
				'wpdevart_education_wda_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'education-wda'),
				'wpdevart_education_wda_fourth_button_slide fourth_btn_slide_right' => esc_html__('Dark', 'education-wda'),
				'wpdevart_education_wda_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'education-wda'),
				'wpdevart_education_wda_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'education-wda'),
				'wpdevart_education_wda_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'education-wda'),
				'wpdevart_education_wda_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'education-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_bg_image',array(
		'default'	=> esc_url(get_theme_file_uri('/images/banner-bg-image.jpg')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_bg_image', array(
        'label' => esc_html__('Banner Background Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~1920*900', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_bg_image',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_image_1',array(
		'default'	=> esc_url(get_theme_file_uri('/images/banner-homepage-image-1.jpg')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_image_1', array(
        'label' => esc_html__('Banner Main Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~800*800', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_image_1',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_image_2',array(
		'default'	=> esc_url(get_theme_file_uri('/images/banner-homepage-image-2.jpg')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_image_2', array(
        'label' => esc_html__('Banner Second Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~800*800', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_image_2',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_image_3',array(
		'default'	=> esc_url(get_theme_file_uri('/images/banner-homepage-image-3.jpg')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_image_3', array(
        'label' => esc_html__('Banner Third Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~800*800', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_image_3',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_banner_image_4',array(
		'default'	=> esc_url(get_theme_file_uri('/images/banner-homepage-image-4.png')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_banner_image_4', array(
        'label' => esc_html__('Banner Fourth Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~800*800', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_banner_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_banner_image_4',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));

	$wp_customize->add_section('wpdevart_education_wda_custom_homepage_call_action_section',array(
		'title'	=> esc_html__('Call to Action Section','education-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_education_wda_custom_homepage_panel'
	));

	$wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_hide_call_action',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_education_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_education_wda_custom_homepage_hide_call_action',
        array(
        'label' => esc_html__( 'Hide Call to Action section', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_education_wda_call_action_section_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_section_bg_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_section_bg_color', array(
		'label' => esc_html__('Section Background Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'settings' => 'wpdevart_education_wda_call_action_section_bg_color'
	)));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_title',array(
		'default'	=> esc_html('Best Offer'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_call_action_title',
            array(
                'label'    => esc_html__('Call to action title','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_call_action_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_call_action_title',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_call_action_section_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_section_title_color', esc_html('#f5f5f5')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_section_title_color', array(
		'label' => esc_html__('Section Title Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'settings' => 'wpdevart_education_wda_call_action_section_title_color'
	)));
	
	$wp_customize->add_setting('wpdevart_education_wda_call_action_section_title_lines_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_section_title_lines_color', esc_html('#433e37')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_section_title_lines_color', array(
		'label' => esc_html__('Section Title Line Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'settings' => 'wpdevart_education_wda_call_action_section_title_lines_color'
	)));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_desc',array(
		'default'	=> esc_html('A brief description of the section below.'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_call_action_desc',
            array(
                'label'    => esc_html__('Call to action description','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_call_action_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_call_action_desc',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_call_action_section_description_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_section_description_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_section_description_color', array(
		'label' => esc_html__('Section Description Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'settings' => 'wpdevart_education_wda_call_action_section_description_color'
	)));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_to_action_image',array(
		'default'	=> esc_url(get_theme_file_uri('/images/call-to-action.jpg')),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_call_to_action_image', array(
        'label' => esc_html__('Call To Action Image','education-wda'),
		'description' => esc_html__( 'Recommended image size ~1200*600', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_call_to_action_image',
        'button_labels' => array(
                    'select' => esc_html__('Select Image','education-wda'),
                    'remove' => esc_html__('Remove Image','education-wda'),
                    'change' => esc_html__('Change Image','education-wda'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_education_wda_call_action_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_bg_color', esc_html('#121212')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_bg_color', array(
        'label' => esc_html__('Call to action background color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
        'settings' => 'wpdevart_education_wda_call_action_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_call_action_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_education_wda_call_action_gradient_type',array(
			'label'	=> esc_html__('Gradient type','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_call_action_section',
			'setting'	=> 'wpdevart_education_wda_call_action_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','education-wda'),
				'to left' => esc_html__('To left','education-wda'),
				'to bottom' => esc_html__('To bottom','education-wda'),
				'to top' => esc_html__('To top','education-wda'),
				'to bottom right' => esc_html__('To bottom right','education-wda'),
				'to bottom left' => esc_html__('To bottom left','education-wda'),
				'to top right' => esc_html__('To top right','education-wda'),
				'to top left' => esc_html__('To top left','education-wda'),
				)
	));	
	$wp_customize->add_setting('wpdevart_education_wda_call_action_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_bg_gradient_color', esc_html('#121212')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_bg_gradient_color', array(
        'label' => esc_html__('Call to action background gradient color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
        'settings' => 'wpdevart_education_wda_call_action_bg_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_sub_title',array(
		'default'	=> esc_html('Call to Action Title'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_call_action_sub_title',
            array(
                'label'    => esc_html__('Call to action subtitle','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_call_action_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_call_action_sub_title',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_call_action_sub_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_sub_title_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_sub_title_color', array(
        'label' => esc_html__('Call to action subtitle color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
        'settings' => 'wpdevart_education_wda_call_action_sub_title_color'
    )));

    $wp_customize->add_setting( 'wpdevart_education_wda_call_action_sub_title_font_size',
    array(
       'default' => esc_html('30'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_call_action_sub_title_font_size',
		array(
		'label' => esc_html__( 'Call to action subtitle font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'input_attrs' => array(
			'min' => esc_html('25'),
			'max' => esc_html('45'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_text',array(
		'default'	=> esc_html('This is sample text for a call to action section. You can use this section to encourage users to click a button and find out more information about your services.'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_call_action_text',
            array(
                'label'    => esc_html__('Call to action text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_call_action_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_call_action_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_call_action_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_call_action_text_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_call_action_text_color', array(
        'label' => esc_html__('Call to action text color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
        'settings' => 'wpdevart_education_wda_call_action_text_color'
    )));

    $wp_customize->add_setting( 'wpdevart_education_wda_call_action_text_font_size',
    array(
       'default' => esc_html('16'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_call_action_text_font_size',
		array(
		'label' => esc_html__( 'Call to action text font-size (px)', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_call_action_section',
		'input_attrs' => array(
			'min' => esc_html('15'),
			'max' => esc_html('45'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_button_text',array(
		'default'	=> esc_html('Check More Details'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_call_action_button_text',
            array(
                'label'    => esc_html__('Call to action button text','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_call_action_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_call_action_button_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_button_url',array(
		'default'	=> esc_url('#'),
		'sanitize_callback'	=> 'wpdevart_education_wda_url_sanitization'	
	));
	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_call_action_button_url',array(
			'label'	=> esc_html__('Call to action button URL','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_call_action_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_call_action_button_url'
	));		

	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_call_action_button_style',array(
		'default'	=> esc_html('wpdevart_education_wda_primary_button_slide primary_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));

	$wp_customize->add_control('wpdevart_education_wda_custom_homepage_call_action_button_style',array(
			'label'	=> esc_html__('Call to action button color','education-wda'),
			'section'	=> 'wpdevart_education_wda_custom_homepage_call_action_section',
			'setting'	=> 'wpdevart_education_wda_custom_homepage_call_action_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_education_wda_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'education-wda'),
				'wpdevart_education_wda_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'education-wda'),
				'wpdevart_education_wda_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'education-wda'),
				'wpdevart_education_wda_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'education-wda'),
				'wpdevart_education_wda_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'education-wda'),
				'wpdevart_education_wda_fourth_button_slide fourth_btn_slide_right' => esc_html__('Dark', 'education-wda'),
				'wpdevart_education_wda_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'education-wda'),
				'wpdevart_education_wda_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'education-wda'),
				'wpdevart_education_wda_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'education-wda'),
				'wpdevart_education_wda_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'education-wda'),
				)
	));	
	$wp_customize->add_section('wpdevart_education_wda_custom_homepage_latest_posts_section',array(
		'title'	=> esc_html__('Latest Posts Section','education-wda'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_education_wda_custom_homepage_panel'
	));

	$wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_hide_latest_post_section',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_education_wda_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_education_wda_custom_homepage_hide_latest_post_section',
        array(
        'label' => esc_html__( 'Hide Latest Posts section', 'education-wda' ),
        'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_education_wda_latest_posts_section_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_latest_posts_section_bg_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_latest_posts_section_bg_color', array(
		'label' => esc_html__('Section Background Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
		'settings' => 'wpdevart_education_wda_latest_posts_section_bg_color'
	)));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_latest_post_title',array(
		'default'	=> esc_html('Latest Posts'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_latest_post_title',
            array(
                'label'    => esc_html__('Latest Posts section title','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_latest_post_title',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_latest_posts_section_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_latest_posts_section_title_color', esc_html('#f5f5f5')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_latest_posts_section_title_color', array(
		'label' => esc_html__('Section Title Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
		'settings' => 'wpdevart_education_wda_latest_posts_section_title_color'
	)));
	
	$wp_customize->add_setting('wpdevart_education_wda_latest_posts_section_title_lines_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_latest_posts_section_title_lines_color', esc_html('#433e37')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_latest_posts_section_title_lines_color', array(
		'label' => esc_html__('Section Title Line Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
		'settings' => 'wpdevart_education_wda_latest_posts_section_title_lines_color'
	)));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_latest_post_desctiption',array(
		'default'	=> esc_html('Latest posts from our blog'),
		'sanitize_callback'	=> 'wpdevart_education_wda_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_education_wda_custom_homepage_latest_post_desctiption',
            array(
                'label'    => esc_html__('Latest Posts section description','education-wda'),
                'section'  => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
                'settings' => 'wpdevart_education_wda_custom_homepage_latest_post_desctiption',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_education_wda_latest_posts_section_description_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_latest_posts_section_description_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_latest_posts_section_description_color', array(
		'label' => esc_html__('Section Description Color','education-wda'),
		'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
		'settings' => 'wpdevart_education_wda_latest_posts_section_description_color'
	)));
	$wp_customize->add_setting( 'wpdevart_education_wda_custom_homepage_number_of_latest_posts',
    array(
       'default' => esc_html('6'),
       'sanitize_callback' => 'wpdevart_education_wda_sanitize_integer'
		)
	);
	$wp_customize->add_control( new Wpdevart_Slider_Custom_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_number_of_latest_posts',
		array(
		'label' => esc_html__( 'The number of posts', 'education-wda' ),
		'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
		'input_attrs' => array(
			'min' => esc_html('1'),
			'max' => esc_html('20'),
			'step' => esc_html('1'),
		),
		)
	) );
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_latest_posts_block_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_latest_posts_block_color', esc_html('#070506')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_latest_posts_block_color', array(
        'label' => esc_html__('Latest posts block bg color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_latest_posts_block_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_latest_posts_title_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_latest_posts_title_color', esc_html('#fdc58a')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_latest_posts_title_color', array(
        'label' => esc_html__('Latest posts title color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_latest_posts_title_color'
    )));
	$wp_customize->add_setting('wpdevart_education_wda_custom_homepage_latest_posts_text_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_education_wda_custom_homepage_latest_posts_text_color', esc_html('#d5d5d5')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_education_wda_custom_homepage_latest_posts_text_color', array(
        'label' => esc_html__('Latest posts text color','education-wda'),
        'section' => 'wpdevart_education_wda_custom_homepage_latest_posts_section',
        'settings' => 'wpdevart_education_wda_custom_homepage_latest_posts_text_color'
    )));